<?php if ($lang == 'en') { ?>

<!DOCTYPE html>
<html lang="en">
<head>
	<meta http-equiv="content-type" content="text/html; charset=utf-8" />
	<title>The Duke's Head</title>
	<base href="{{base_url}}" />
			<meta name="viewport" content="width=992" />
		<meta name="description" content="" />
	<meta name="keywords" content="" />
		<meta name="generator" content="Site.pro Website builder" />
	
	<link href="css/bootstrap.min.css" rel="stylesheet" type="text/css" />
	<script src="js/jquery-1.11.3.min.js" type="text/javascript"></script>
	<script src="js/bootstrap.min.js" type="text/javascript"></script>
	<script src="js/main.js" type="text/javascript"></script>

	<link href="css/site.css?v=1.1.40" rel="stylesheet" type="text/css" />
	<link href="css/common.css?ts=1486332112" rel="stylesheet" type="text/css" />
	<link href="css/3.css?ts=1486332112" rel="stylesheet" type="text/css" />
	<link rel="shortcut icon" href="/gallery/favicon2-ts1485471431.png" type="image/png" />
	<script type="text/javascript">var currLang = 'en';</script>		
	<!-- Le HTML5 shim, for IE6-8 support of HTML5 elements -->
	<!--[if lt IE 9]>
	  <script src="http://html5shim.googlecode.com/svn/trunk/html5.js"></script>
	<![endif]-->
</head>


<body>{{ga_code}}<div class="root"><div class="vbox wb_container" id="wb_header">
	
<div id="wb_element_instance166" class="wb_element"><ul class="hmenu"><li><a href="en/Home/" target="_self" title="Home">Home</a></li><li class="active"><a href="en/Projects/" target="_self" title="Projects">Projects</a><ul><li><a href="en/Critical-Analysis/" target="_self" title="Critical Analysis">Critical Analysis</a></li><li><a href="en/FrankiesFav/" target="_self" title="#FrankiesFav">#FrankiesFav</a></li><li class="active"><a href="en/The-Dukes-Head/" target="_self" title="The Duke's Head">The Duke's Head</a></li><li><a href="en/Corporate-Video/" target="_self" title="Corporate Video">Corporate Video</a></li><li><a href="en/Miscellaneous/" target="_self" title="Miscellaneous">Miscellaneous</a></li></ul></li><li><a href="en/Photography/" target="_self" title="Photography">Photography</a></li><li><a href="en/About/" target="_self" title="About">About</a></li><li><a href="en/Contact/" target="_self" title="Contact">Contact</a></li></ul></div></div>
<div class="vbox wb_container" id="wb_main">
	
<div id="wb_element_instance169" class="wb_element" style=" line-height: normal;"><h4 class="wb-stl-pagetitle" style="text-align: center;">the duke's head</h4>
</div><div id="wb_element_instance170" class="wb_element" style=" line-height: normal;"><h5 class="wb-stl-subtitle"><span style="color:#474747;"><strong><u>Client:</u> The Duke's Head, Armathwaite (Punch Taverns)</strong></span></h5>

<h5 class="wb-stl-subtitle"> </h5>

<h5 class="wb-stl-subtitle"><span style="color:#474747;"><strong><u>Brief:</u> Create a vectorised logo from an image taken of traditional painting for engraving</strong></span></h5>
</div><div id="wb_element_instance171" class="wb_element" style=" line-height: normal;"><h5 class="wb-stl-subtitle" style="text-align: justify;"><span style="color:#474747;"><strong>Follow-on work from this client</strong></span></h5>

<p class="wb-stl-normal" style="text-align: justify;"><span style="color:#474747;">Following this successful project I was asked to create several pieces of advertising and branding for them.</span></p>
</div><div id="wb_element_instance172" class="wb_element" style=" line-height: normal;"><p class="wb-stl-normal" style="text-align: center;"><span style="color:#000000;"><strong>6'x4' Double Sided Correx Billboard</strong></span></p>
</div><div id="wb_element_instance173" class="wb_element" style=" line-height: normal;"><p class="wb-stl-normal" style="text-align: center;"><span style="color:#000000;"><strong>A4 Music Night Poster</strong></span></p>
</div><div id="wb_element_instance174" class="wb_element"><img alt="a4-letterhead" src="gallery_gen/c3e91f85243cfd7425d01d1fa70ef0d5_270x380.png"></div><div id="wb_element_instance175" class="wb_element" style=" line-height: normal;"><p class="wb-stl-normal" style="text-align: center;"><span style="color:#000000;"><strong>A4 Letterheads</strong></span></p>
</div><div id="wb_element_instance176" class="wb_element"><img alt="8'x2' correx" src="gallery_gen/49a35bc4ff9011a30bd5e7ab95e73a38_910x230.png"></div><div id="wb_element_instance177" class="wb_element" style=" line-height: normal;"><p class="wb-stl-normal" style="text-align: center;"><span style="color:#000000;"><strong>8'x2' Correx Directional Sign</strong></span></p>
</div><div id="wb_element_instance178" class="wb_element"><img alt="1000x1000logo-vector" src="gallery_gen/85de038814a3074f84bdc811ba1042fb_490x430.png"></div><div id="wb_element_instance179" class="wb_element"><img alt="1000px-painting-bright" src="gallery_gen/b091ea79bc20a4bf0da7ffb69aae407b_320x430.png"></div><div id="wb_element_instance180" class="wb_element"><img alt="1000x1000live trace" src="gallery_gen/1c1ba4cd61a3ea8eca8e879da2a5b2ba_320x360.png"></div><div id="wb_element_instance181" class="wb_element"><img alt="1000px lt-a4clipboard-01-01" src="gallery_gen/ff7c36eb6e6c2cb730b2e6e1c7f4f717_310x420.png"></div><div id="wb_element_instance182" class="wb_element"><img alt="1000px-outline" src="gallery_gen/cbb3f5d42da729f5c2ca9bf00c2e3516_400x430.png"></div><div id="wb_element_instance183" class="wb_element"><img alt="1000px-cb-mc-ch-engrave-01-02" src="gallery_gen/32f05bb0474f2ea8cd20f89ac9a8b50e_790x420.png"></div><div id="wb_element_instance184" class="wb_element"><img alt="1000x1000-cb-mc-ch-02" src="gallery_gen/5ec9fa912d3c97ed5033bb625b7508da_790x420.png"></div><div id="wb_element_instance185" class="wb_element"><img alt="a4-live-music-poster" src="gallery_gen/9eb4c40b6a5847128f84e4246e635293_270x380.png"></div><div id="wb_element_instance186" class="wb_element"><img alt="6'x4'-billboard-left" src="gallery_gen/f4958c1e63e461d45d2392d99f52fdfb_440x300.png"></div><div id="wb_element_instance187" class="wb_element"><img alt="6'x4'-billboard-right" src="gallery_gen/c7aea6ef2451ce115ca662505f7bf7fe_460x300.png"></div><div id="wb_element_instance188" class="wb_element" style=" line-height: normal;"><h5 class="wb-stl-subtitle" style="text-align: justify;"><span style="color:#474747;">Challenges</span></h5>

<p class="wb-stl-normal" style="text-align: justify;"><span style="color:#474747;">Punch Taverns provided the photo image shown here, to be reproduced on A4 clipboards, A4 menu covers and condiment holders.</span></p>

<p class="wb-stl-normal" style="text-align: justify;"> </p>

<p class="wb-stl-normal" style="text-align: justify;"><span style="color:#474747;">There are significant technical challenges with reproducing complex artwork for engraved products. For example:</span></p>

<p class="wb-stl-normal" style="text-align: justify;"> </p>

<p class="wb-stl-normal" style="text-align: justify;"><span style="color:#474747;">• The engraver requires a vector file, usually generated from Adobe Illustrator, and so the photo image would have to be converted by tracing or outlining.</span></p>

<p class="wb-stl-normal" style="text-align: justify;"> </p>

<p class="wb-stl-normal" style="text-align: justify;"><span style="color:#474747;">• Using the Live Trace feature in Illustrator would significantly speed up the design process, but at the possible expense of lower image quality and detail.</span></p>

<p class="wb-stl-normal" style="text-align: justify;"> </p>

<p class="wb-stl-normal" style="text-align: justify;"><span style="color:#474747;">•</span> <span style="color:#474747;">The success of a Live Trace depends upon Illustrator’s ability to detect boundaries of colour. On a complex image the boundaries may not be clear.</span></p>
</div><div id="wb_element_instance189" class="wb_element"><img alt="1000px-painting-original" src="gallery_gen/c4c1ff5098edffb491632ea4a4925e94_320x430.png"></div><div id="wb_element_instance190" class="wb_element" style=" line-height: normal;"><h5 class="wb-stl-subtitle" style="text-align: justify;">Live Trace</h5>

<p class="wb-stl-normal" style="text-align: justify;"><span style="color:#474747;">To cut down on design time I decided to try Live Trace. Following an initial failed attempt using the original image, I found it necessary to use Photoshop to increase vibrance. I expected the results of Live Trace to be clearer and more precise.</span></p>
</div><div id="wb_element_instance191" class="wb_element" style=" line-height: normal;"><p class="wb-stl-normal" style="text-align: center;"><span style="color:#000000;"><strong>Original image</strong></span></p>
</div><div id="wb_element_instance192" class="wb_element" style=" line-height: normal;"><p class="wb-stl-normal" style="text-align: justify;"><span style="color:#474747;">This experiment did not turn out as I had hoped. The problem is plain to see in the negative image where the detailing on the left of the shield has completely disappeared, and there is far too much negative space elsewhere too. Not only would the engraver need to take out a large amount of wood (the black areas), but the overall engraved image would be almost unrecognisable as the original coat of arms. </span></p>
</div><div id="wb_element_instance193" class="wb_element" style=" line-height: normal;"><p class="wb-stl-normal" style="text-align: center;"><span style="color:#000000;"><strong>Enhanced image from Photoshop</strong></span></p>
</div><div id="wb_element_instance194" class="wb_element" style=" line-height: normal;"><p class="wb-stl-normal" style="text-align: center;"><span style="color:#000000;"><strong>Result of the Live Trace</strong></span></p>
</div><div id="wb_element_instance195" class="wb_element" style=" line-height: normal;"><p class="wb-stl-normal" style="text-align: center;"><span style="color:#000000;"><strong>First proof sent to client</strong></span></p>
</div><div id="wb_element_instance196" class="wb_element" style=" line-height: normal;"><p class="wb-stl-normal" style="text-align: justify;"><span style="color:#474747;">It was important to inform the client of this, and did so by sending them a proof of a dark wooden clipboard with the design as seen here, describing the process and explaining why it would have been difficult to achieve good results in the desired timescale.</span></p>
</div><div id="wb_element_instance197" class="wb_element" style=" line-height: normal;"><h5 class="wb-stl-subtitle" style="text-align: justify;"><span style="color:#474747;">Manual trace</span></h5>

<p class="wb-stl-normal" style="text-align: justify;"><span style="color:#474747;">I offered a solution using a manual trace method explaining that we should expect much more control over the final engraving quality and machine time, but that it would take longer to design. I explained that this would incur a surcharge (MAJIsign design services are normally provided free of charge). The client agreed.</span></p>
</div><div id="wb_element_instance198" class="wb_element" style=" line-height: normal;"><p class="wb-stl-normal" style="text-align: justify;"><span style="color:#474747;">The detailed manual tracing took approximately 6 hours, and I sent new proofs of the clipboard, menu cover and condiment holder. All three showed a reasonable resemblance to the original coat of arms, and the client was happy with the outcome, and signed them off.</span></p>
</div><div id="wb_element_instance199" class="wb_element" style=" line-height: normal;"><h5 class="wb-stl-subtitle">The Finished Product</h5>

<p class="wb-stl-normal" style="text-align: justify;"><span style="color:#474747;">I could now move on to setting these up as engraving files. This involves cleaning the images to contain only the lines to be engraved and the object outline so that engraved images are correctly placed. They are saved as EPS files and then converted to DXF files using CAD software.</span></p>
</div><div id="wb_element_instance200" class="wb_element" style=" line-height: normal;"><p class="wb-stl-normal" style="text-align: center;"><span style="color:#000000;"><strong>EPS files ready to be converted to DXF</strong></span></p>
</div><div id="wb_element_instance201" class="wb_element" style=" line-height: normal;"><p class="wb-stl-normal" style="text-align: center;"><span style="color:#000000;"><strong>Outline of engraving</strong></span></p>
</div><div id="wb_element_instance202" class="wb_element" style=" line-height: normal;"><p class="wb-stl-normal" style="text-align: justify;"><span style="color:#000000;"><strong>Outlined image in Illustrator showing anchor points and vector paths</strong></span></p>
</div><div id="wb_element_instance203" class="wb_element" style=" line-height: normal;"><p class="wb-stl-normal" style="text-align: center;"><span style="color:#000000;"><strong>Final proofs sent to customer</strong></span></p>
</div><div id="wb_element_instance204" class="wb_element" style="width: 100%;">
			<?php
				global $show_comments;
				if (isset($show_comments) && $show_comments) {
					renderComments(3);
			?>
			<script type="text/javascript">
				$(function() {
					var block = $("#wb_element_instance204");
					var comments = block.children(".wb_comments").eq(0);
					var contentBlock = $("#wb_main");
					contentBlock.height(contentBlock.height() + comments.height());
				});
			</script>
			<?php
				} else {
			?>
			<script type="text/javascript">
				$(function() {
					$("#wb_element_instance204").hide();
				});
			</script>
			<?php
				}
			?>
			</div></div>
<div class="vbox wb_container" id="wb_footer" style="height: 114px;">
	
<div id="wb_element_instance167" class="wb_element"><a href="http://www.nativespace.com/"><img alt="http://wizard.nativespace.com/builder-logo" src="gallery_gen/c741c98420bb89fe89d652620bfa4291_112x39.png"></a></div><div id="wb_element_instance168" class="wb_element" style=" line-height: normal;"><p class="wb-stl-footer" style="text-align: center;">© 2017 <a href="http://naomiwinter.co.uk"><span style="color:#000000;">naomiwinter.co.uk</span></a></p>
</div><div id="wb_element_instance205" class="wb_element" style="text-align: center; width: 100%;"><div class="wb_footer"></div><script type="text/javascript">
			$(function() {
				var footer = $(".wb_footer");
				var html = (footer.html() + "").replace(/^\s+|\s+$/g, "");
				if (!html) {
					footer.parent().remove();
					footer = $("#wb_footer");
					footer.height(50);
				}
			});
			</script></div></div><div class="wb_sbg"></div></div></body>
</html>


<?php } ?>
