<?php if ($lang == 'en') { ?>

<!DOCTYPE html>
<html lang="en">
<head>
	<meta http-equiv="content-type" content="text/html; charset=utf-8" />
	<title>Corporate Video</title>
	<base href="{{base_url}}" />
			<meta name="viewport" content="width=992" />
		<meta name="description" content="" />
	<meta name="keywords" content="" />
		<meta name="generator" content="Site.pro Website builder" />
	
	<link href="css/bootstrap.min.css" rel="stylesheet" type="text/css" />
	<script src="js/jquery-1.11.3.min.js" type="text/javascript"></script>
	<script src="js/bootstrap.min.js" type="text/javascript"></script>
	<script src="js/main.js" type="text/javascript"></script>

	<link href="css/site.css?v=1.1.40" rel="stylesheet" type="text/css" />
	<link href="css/common.css?ts=1486332114" rel="stylesheet" type="text/css" />
	<link href="css/6.css?ts=1486332114" rel="stylesheet" type="text/css" />
	<link rel="shortcut icon" href="/gallery/favicon2-ts1485471431.png" type="image/png" />
	<script type="text/javascript">var currLang = 'en';</script>		
	<!-- Le HTML5 shim, for IE6-8 support of HTML5 elements -->
	<!--[if lt IE 9]>
	  <script src="http://html5shim.googlecode.com/svn/trunk/html5.js"></script>
	<![endif]-->
</head>


<body>{{ga_code}}<div class="root"><div class="vbox wb_container" id="wb_header">
	
<div id="wb_element_instance206" class="wb_element"><ul class="hmenu"><li><a href="en/Home/" target="_self" title="Home">Home</a></li><li class="active"><a href="en/Projects/" target="_self" title="Projects">Projects</a><ul><li><a href="en/Critical-Analysis/" target="_self" title="Critical Analysis">Critical Analysis</a></li><li><a href="en/FrankiesFav/" target="_self" title="#FrankiesFav">#FrankiesFav</a></li><li><a href="en/The-Dukes-Head/" target="_self" title="The Duke's Head">The Duke's Head</a></li><li class="active"><a href="en/Corporate-Video/" target="_self" title="Corporate Video">Corporate Video</a></li><li><a href="en/Miscellaneous/" target="_self" title="Miscellaneous">Miscellaneous</a></li></ul></li><li><a href="en/Photography/" target="_self" title="Photography">Photography</a></li><li><a href="en/About/" target="_self" title="About">About</a></li><li><a href="en/Contact/" target="_self" title="Contact">Contact</a></li></ul></div></div>
<div class="vbox wb_container" id="wb_main">
	
<div id="wb_element_instance209" class="wb_element" style=" line-height: normal;"><h4 class="wb-stl-pagetitle" style="text-align: center;">corporate video</h4>
</div><div id="wb_element_instance210" class="wb_element" style=" line-height: normal;"><h5 class="wb-stl-subtitle"><span style="color:#474747;"><strong><u>Client:</u> MAJIsign Ltd.</strong></span></h5>

<p> </p>

<h5 class="wb-stl-subtitle"><span style="color:#474747;"><strong><u>Brief:</u> Create a corporate video to support MAJIsign’s marketing presentations.</strong></span></h5>
</div><div id="wb_element_instance211" class="wb_element"><iframe title="YouTube video player" class="youtube-player" allowfullscreen="" type="text/html" src="//www.youtube.com/embed/O6qxxni1SCQ" frameborder="0"></iframe></div><div id="wb_element_instance212" class="wb_element"><iframe title="YouTube video player" class="youtube-player" allowfullscreen="" type="text/html" src="//www.youtube.com/embed/XGnw79TIhn4" frameborder="0"></iframe></div><div id="wb_element_instance213" class="wb_element" style=" line-height: normal;"><h5 class="wb-stl-subtitle" style="text-align: center;"><span style="color:#000000;"><strong>Long Video - 5:34</strong></span></h5>
</div><div id="wb_element_instance214" class="wb_element" style=" line-height: normal;"><h5 class="wb-stl-subtitle" style="text-align: center;"><span style="color:#000000;"><strong>Short Video - 1:08</strong></span></h5>
</div><div id="wb_element_instance215" class="wb_element" style=" line-height: normal;"><p class="wb-stl-normal" style="text-align: justify;"><span style="color:#474747;">I was presented with a unique and exciting opportunity to take overall responsibility for producing a corporate video for MAJIsign, from idea creation to publish. This was executed in three stages, pre-production planning, production and post-production, each with its own challenges.</span></p>
</div><div id="wb_element_instance216" class="wb_element" style=" line-height: normal;"><h5 class="wb-stl-subtitle" style="text-align: justify;">The Pre-Production Stage</h5>

<p class="wb-stl-normal" style="text-align: justify;"><span style="color:#474747;">It’s fair to say that there was much more to this project than I had first expected. I quickly recognised that a solid foundation with clear objectives would avoid costly re-shooting and re-editing. The main tasks I identified after early brainstorming were</span><span style="color:#474747;">:</span></p>

<p class="wb-stl-normal" style="text-align: justify;"> </p>

<p class="wb-stl-normal" style="text-align: justify;"><span style="color:#474747;">• Identify the purpose and target audience of this video within the marketing strategy.</span></p>

<p class="wb-stl-normal" style="text-align: justify;">  -<span style="color:#474747;"> Engage with the company director and marketing team.</span></p>

<p class="wb-stl-normal" style="text-align: justify;"><span style="color:#474747;">• Broadly identify the video content, props, locations, cast, timing and narrative.</span></p>

<p class="wb-stl-normal" style="text-align: justify;"><span style="color:#474747;">  - Storyboarding.</span></p>

<p class="wb-stl-normal" style="text-align: justify;"><span style="color:#474747;">  - Getting the best specialist technical advice from machine operators, sprayers, assemblers and packing and dispatch staff.</span></p>

<p class="wb-stl-normal" style="text-align: justify;"><span style="color:#474747;">  - Understand access to facilities and industrial machinery in the factory.</span></p>

<p class="wb-stl-normal">  -<span style="color:#474747;"> Identify any health and safety issues.</span></p>

<p class="wb-stl-normal" style="text-align: justify;"><span style="color:#474747;">• Identify the need for more than one version to cover several media channels.</span></p>

<p class="wb-stl-normal" style="text-align: justify;"><span style="color:#474747;">  - Company website, trade shows, corporate events.</span></p>

<p class="wb-stl-normal" style="text-align: justify;"><span style="color:#474747;">  - YouTube, Facebook, Instagram, Twitter.</span></p>

<p class="wb-stl-normal" style="text-align: justify;"><span style="color:#474747;">• Research similar industrial production process videos.</span></p>

<p class="wb-stl-normal" style="text-align: justify;"><span style="color:#474747;">  - Snowboards - Inspiration for using a GoPro and for the opening and closing scenes (GoPro YouTube channel).</span></p>

<p class="wb-stl-normal" style="text-align: justify;">  - <span style="color:#474747;">Cars - Filming inside industrial machinery (Manufacturing process of Model S TESLA in factory).</span></p>
</div><div id="wb_element_instance217" class="wb_element" style=" line-height: normal;"><p class="wb-stl-normal" style="text-align: justify;"><strong><u><span style="color:#474747;">Purpose</span></u></strong></p>

<p class="wb-stl-normal" style="text-align: justify;"><span style="color:#474747;">The key message of this video is that most of MAJIsign’s products are designed, customised, cut to size, printed, engraved, assembled, packaged and sold from a factory unit in Bury St Edmunds by a small team of dedicated craftspeople.</span></p>

<p class="wb-stl-normal" style="text-align: justify;"> </p>

<p class="wb-stl-normal" style="text-align: justify;"><u><strong><span style="color:#474747;">Audience, Content and Format</span></strong></u></p>

<p class="wb-stl-normal" style="text-align: justify;"><span style="color:#474747;">The company director requested a video of around five minutes to be used in “captive audience” situations such as trade shows and corporate events. In addition, the marketing team wanted a sixty second video for social media channels to capture audience attention quickly.</span></p>

<p class="wb-stl-normal" style="text-align: justify;"> </p>

<p class="wb-stl-normal" style="text-align: justify;"><span style="color:#474747;">The long video was to offer an insight into the production process required to make and assemble one of their most popular products, the premium wooden A-board and to showcase other products and processes undertaken in the factory. The short video was to be summary of these activities.</span></p>

<p class="wb-stl-normal" style="text-align: justify;"> </p>

<p class="wb-stl-normal" style="text-align: justify;"><span style="color:#474747;">A key requirement was that the videos should tell a story without dialogue. This is especially important during the hustle and bustle of busy trade shows where buyers must be attracted by visual information.</span></p>
</div><div id="wb_element_instance218" class="wb_element"><img alt="screen shot 2017-02-03 at 15.55.33" src="gallery_gen/cfc21d9644ed82f7ea4287d228fe96e8_430x540.png"></div><div id="wb_element_instance219" class="wb_element" style=" line-height: normal;"><p class="wb-stl-normal" style="text-align: justify;"><span style="color:#474747;"><u><strong>Idea Development</strong></u></span></p>

<p class="wb-stl-normal" style="text-align: justify;"><span style="color:#474747;">I interviewed every member of staff involved in the production process and documented their input. As ideas evolved, from many different points of view, the storyboard developed too. Along with the planned timeline of events I also considered camera angles, lighting and transitions.</span></p>

<p class="wb-stl-normal" style="text-align: justify;"> </p>

<p class="wb-stl-normal" style="text-align: justify;"><span style="color:#474747;">MAJIsign hired a professional videographer to undertake the filming and post-production work. Dan and I had been collaborating from the start of the project to ensure that my ideas were practical and achievable. He added a great deal of experience to the project. His technical knowledge coupled with my original research to work with a GoPro camera offered a unique insight into industrial CNC machines, giving the audience a real sense of being on the production line.</span></p>
</div><div id="wb_element_instance220" class="wb_element"><img alt="storyboard-01" src="gallery_gen/3815c6c0ec031132f76451a52d001c30_930x180.png"></div><div id="wb_element_instance221" class="wb_element" style=" line-height: normal;"><h5 class="wb-stl-subtitle" style="text-align: justify;"><span style="color:#474747;">The Production Stage</span></h5>

<p class="wb-stl-normal"><span style="color:#474747;">Following detailed planning, this stage turned out to be straight forward. There were some technical challenges to overcome during filming, but we were able to stick to the plan in all key respects.</span></p>

<p class="wb-stl-normal"> </p>

<p class="wb-stl-normal"><span style="color:#474747;">Filming took place over two weeks, and not necessarily in the order that it would appear on screen. My colleagues were very interested in the process, and I spent quite some time listening to their comments. It was important to develop good working relationships at all levels to ensure filming stayed on schedule in a busy manufacturing environment. All the staff were very supportive, and this exercise taught me a lot about the way a factory works.</span></p>

<p class="wb-stl-normal"> </p>

<h5 class="wb-stl-subtitle" style="text-align: justify;"><span style="color:#474747;">The Post-Production Stage</span></h5>

<p class="wb-stl-normal" style="text-align: justify;"><span style="color:#474747;">Dan performed the final editing off site, but continued to keep in contact to discuss alterations. He came to my office to demonstrate progress so far on a few occasions, and we worked closely to create the final product.</span></p>

<p style="text-align: justify;"> </p>

<h5 class="wb-stl-subtitle"><span style="color:#474747;">Conclusion</span></h5>

<p class="wb-stl-normal"><span style="color:#474747;">This significant task made for a very interesting work experience throughout. It has been very exciting to see the final results published on YouTube, and to know that the marketing and sales teams will use them for many years to come.</span></p>
</div><div id="wb_element_instance222" class="wb_element" style=" line-height: normal;"><p class="wb-stl-normal" style="text-align: center;"><strong>Screenshot of A-Board (Source: www.majisign.co.uk)</strong></p>
</div><div id="wb_element_instance223" class="wb_element" style=" line-height: normal;"><p class="wb-stl-normal" style="text-align: center;"><strong>Original storyboard</strong></p>
</div><div id="wb_element_instance224" class="wb_element" style="width: 100%;">
			<?php
				global $show_comments;
				if (isset($show_comments) && $show_comments) {
					renderComments(6);
			?>
			<script type="text/javascript">
				$(function() {
					var block = $("#wb_element_instance224");
					var comments = block.children(".wb_comments").eq(0);
					var contentBlock = $("#wb_main");
					contentBlock.height(contentBlock.height() + comments.height());
				});
			</script>
			<?php
				} else {
			?>
			<script type="text/javascript">
				$(function() {
					$("#wb_element_instance224").hide();
				});
			</script>
			<?php
				}
			?>
			</div></div>
<div class="vbox wb_container" id="wb_footer" style="height: 114px;">
	
<div id="wb_element_instance207" class="wb_element"><a href="http://www.nativespace.com/"><img alt="http://wizard.nativespace.com/builder-logo" src="gallery_gen/c741c98420bb89fe89d652620bfa4291_112x39.png"></a></div><div id="wb_element_instance208" class="wb_element" style=" line-height: normal;"><p class="wb-stl-footer" style="text-align: center;">© 2017 <a href="http://naomiwinter.co.uk"><span style="color:#000000;">naomiwinter.co.uk</span></a></p>
</div><div id="wb_element_instance225" class="wb_element" style="text-align: center; width: 100%;"><div class="wb_footer"></div><script type="text/javascript">
			$(function() {
				var footer = $(".wb_footer");
				var html = (footer.html() + "").replace(/^\s+|\s+$/g, "");
				if (!html) {
					footer.parent().remove();
					footer = $("#wb_footer");
					footer.height(50);
				}
			});
			</script></div></div><div class="wb_sbg"></div></div></body>
</html>


<?php } ?>
